# راهنمای نصب و راه‌اندازی درگاه پرداخت MaxelPay

## مراحل نصب

### 1. افزودن فیلدهای دیتابیس

فایل SQL زیر را در دیتابیس خود اجرا کنید:

```sql
-- فایل: assets/backup_db/add_maxelpay_fields.sql
ALTER TABLE `payment_config` 
ADD COLUMN `maxelpay_api_key` text COLLATE utf8mb4_unicode_ci NOT NULL AFTER `paymaya_mode`,
ADD COLUMN `maxelpay_secret_key` text COLLATE utf8mb4_unicode_ci NOT NULL AFTER `maxelpay_api_key`,
ADD COLUMN `maxelpay_mode` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'live' AFTER `maxelpay_secret_key`;
```

یا می‌توانید مستقیماً از phpMyAdmin یا هر ابزار مدیریت دیتابیس استفاده کنید.

### 2. اضافه کردن آیکون MaxelPay

لطفاً آیکون MaxelPay را در مسیر زیر قرار دهید:
- مسیر: `assets/img/payment/maxelpay.png`
- اندازه پیشنهادی: 60x60 پیکسل یا بیشتر
- فرمت: PNG با پس‌زمینه شفاف یا سفید

برای دریافت آیکون:
- از وب‌سایت رسمی MaxelPay دانلود کنید
- یا از پنل مدیریت MaxelPay خود دریافت کنید

### 3. تنظیم URL های API

**مهم:** لطفاً URL های API را در فایل `application/libraries/Maxelpay.php` با مستندات رسمی MaxelPay تطبیق دهید.

فایل فعلی از URL های پیش‌فرض زیر استفاده می‌کند:
- Sandbox: `https://sandbox.maxelpay.com/api/v1/`
- Live: `https://api.maxelpay.com/api/v1/`

**لطفاً این URL ها را با URL های واقعی از مستندات MaxelPay جایگزین کنید.**

برای پیدا کردن URL های صحیح:
1. به پنل مدیریت MaxelPay خود وارد شوید
2. به بخش API Documentation مراجعه کنید
3. URL های Base API را پیدا کنید
4. در فایل `Maxelpay.php` در خطوط 34 و 36، URL ها را به‌روزرسانی کنید

### 4. تنظیمات در پنل مدیریت

1. به پنل مدیریت سیستم وارد شوید
2. به بخش **Integration > Payment Accounts** بروید
3. فیلدهای زیر را پر کنید:
   - **MaxelPay API Key**: کلید API خود را از پنل MaxelPay وارد کنید
   - **MaxelPay Secret Key**: کلید Secret خود را از پنل MaxelPay وارد کنید
   - **MaxelPay Sandbox Mode**: برای تست، این گزینه را فعال کنید

### 5. تست درگاه پرداخت

1. یک تراکنش تستی ایجاد کنید
2. درگاه MaxelPay را انتخاب کنید
3. پرداخت را انجام دهید
4. بررسی کنید که تراکنش به درستی ثبت می‌شود

## نکات مهم

### تطبیق ساختار API

ساختار API در کلاس `Maxelpay.php` بر اساس الگوی استاندارد درگاه‌های پرداخت طراحی شده است. ممکن است نیاز باشد که:

1. **نام فیلدهای Request**: در متد `create_payment()` بررسی کنید که نام فیلدها با API واقعی MaxelPay مطابقت دارد
2. **ساختار Response**: در متدهای `verify_payment()` و `success_action()` بررسی کنید که ساختار پاسخ با API واقعی مطابقت دارد
3. **نوع Authentication**: ممکن است MaxelPay از روش دیگری برای احراز هویت استفاده کند (مثلاً Basic Auth به جای Bearer Token)

### بررسی فیلدهای Response

در متد `process_maxelpay_payment()` در فایل `Stripe_action.php`، فیلدهای زیر از Response استخراج می‌شوند:
- `customer_email`
- `payment_date`
- `order_id`

لطفاً این فیلدها را با ساختار واقعی Response از MaxelPay تطبیق دهید.

## پشتیبانی

در صورت بروز مشکل:
1. لاگ‌های خطا را بررسی کنید
2. مستندات رسمی MaxelPay را مطالعه کنید
3. با پشتیبانی MaxelPay تماس بگیرید

## فایل‌های ایجاد شده

- `application/libraries/Maxelpay.php` - کلاس کتابخانه MaxelPay
- `application/controllers/maxelpay_methods_to_add.php` - متدهای callback (باید به Stripe_action.php اضافه شوند)
- `assets/backup_db/add_maxelpay_fields.sql` - اسکریپت SQL برای افزودن فیلدها
- `assets/img/payment/MAXELPAY_ICON_README.txt` - راهنمای آیکون

## وضعیت نصب

✅ کلاس کتابخانه ایجاد شد
✅ فیلدهای تنظیمات اضافه شد
✅ UI تنظیمات اضافه شد
✅ دکمه پرداخت اضافه شد
✅ متدهای callback آماده است
⏳ فیلدهای دیتابیس باید اضافه شوند (فایل SQL آماده است)
⏳ آیکون باید اضافه شود
⏳ URL های API باید تطبیق داده شوند

