<?php
// این متدها باید قبل از بریس بسته کلاس در فایل Stripe_action.php (قبل از خط 4990) اضافه شوند

    public function maxelpay_action()
    {
        $package_id = $this->uri->segment(3);
        $user_id = $this->uri->segment(4);

        $package_info = $this->basic->get_data('package',['where'=>['id'=>$package_id]],['package_name','price']);
        $payment_amount = isset($package_info[0]['price']) ? $package_info[0]['price'] : '';
        $package_name = isset($package_info[0]['package_name']) ? $package_info[0]['package_name'] : '';

        $user_info = $this->basic->get_data('users',['where'=>['id'=>$user_id]],['name','email','mobile']);
        $user_name = isset($user_info[0]['name']) ? $user_info[0]['name'] : '';
        $user_email = isset($user_info[0]['email']) ? $user_info[0]['email'] : '';
        $user_mobile = isset($user_info[0]['mobile']) ? $user_info[0]['mobile'] : '';

        $where['where'] = array('deleted'=>'0');
        $payment_config = $this->basic->get_data('payment_config',$where,$select='');
        $currency = isset($payment_config[0]['currency']) ? $payment_config[0]['currency'] : 'USD';

        $redirect_url_maxelpay = base_url('stripe_action/maxelpay_success/').$package_id.'/'.$user_id;
        $callback_url_maxelpay = base_url('stripe_action/maxelpay_callback/');

        $this->load->library('maxelpay');
        $this->maxelpay->redirect_url = $redirect_url_maxelpay;
        $this->maxelpay->callback_url = $callback_url_maxelpay;
        $this->maxelpay->amount = $payment_amount;
        $this->maxelpay->currency = $currency;
        $this->maxelpay->order_id = 'maxelpay_'.$package_id.'_'.$user_id.'_'.time();
        $this->maxelpay->purpose = $this->config->item("product_name")." : ".$package_name;
        $this->maxelpay->buyer_name = $user_name;
        $this->maxelpay->email = $user_email;
        $this->maxelpay->phone = $user_mobile;

        $this->session->set_userdata('maxelpay_payment_package_id', $package_id);
        $this->session->set_userdata('maxelpay_payment_user_id', $user_id);
        $this->session->set_userdata('maxelpay_payment_amount', $payment_amount);

        $response = $this->maxelpay->create_payment();

        if(isset($response['status']) && $response['status'] == 'success' && isset($response['payment_url'])) {
            header('Location: '.$response['payment_url']);
            exit;
        } else {
            $error_message = isset($response['message']) ? $response['message'] : 'Payment creation failed';
            $redirect_url = base_url()."payment/transaction_log?action=cancel&error=".urlencode($error_message);
            redirect($redirect_url, 'refresh');
        }
    }

    public function maxelpay_success()
    {
        $package_id = $this->uri->segment(3);
        $user_id = $this->uri->segment(4);

        $payment_id = isset($_GET['payment_id']) ? $_GET['payment_id'] : '';
        if(empty($payment_id)) {
            $payment_id = isset($_POST['payment_id']) ? $_POST['payment_id'] : '';
        }

        if(empty($payment_id)) {
            $redirect_url = base_url()."payment/transaction_log?action=cancel";
            redirect($redirect_url, 'refresh');
            return;
        }

        $this->load->library('maxelpay');
        $this->maxelpay->payment_id = $payment_id;
        $response = $this->maxelpay->verify_payment($payment_id);

        if(isset($response['status']) && ($response['status'] == 'success' || $response['status'] == 'paid' || $response['status'] == 'completed')) {
            $this->process_maxelpay_payment($package_id, $user_id, $payment_id, $response);
        } else {
            $redirect_url = base_url()."payment/transaction_log?action=cancel";
            redirect($redirect_url, 'refresh');
        }
    }

    public function maxelpay_callback()
    {
        $payment_id = isset($_POST['payment_id']) ? $_POST['payment_id'] : '';
        if(empty($payment_id)) {
            $payment_id = isset($_GET['payment_id']) ? $_GET['payment_id'] : '';
        }

        if(empty($payment_id)) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Payment ID not found']);
            return;
        }

        $this->load->library('maxelpay');
        $response = $this->maxelpay->verify_payment($payment_id);

        if(isset($response['status']) && ($response['status'] == 'success' || $response['status'] == 'paid' || $response['status'] == 'completed')) {
            $order_id = isset($response['order_id']) ? $response['order_id'] : '';
            if(!empty($order_id)) {
                $order_parts = explode('_', $order_id);
                if(count($order_parts) >= 3) {
                    $package_id = isset($order_parts[1]) ? $order_parts[1] : '';
                    $user_id = isset($order_parts[2]) ? $order_parts[2] : '';
                    if(!empty($package_id) && !empty($user_id)) {
                        $this->process_maxelpay_payment($package_id, $user_id, $payment_id, $response);
                    }
                }
            }
            http_response_code(200);
            echo json_encode(['status' => 'success']);
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Payment verification failed']);
        }
    }

    private function process_maxelpay_payment($package_id, $user_id, $transaction_id, $response)
    {
        $simple_where['where'] = array('user_id'=>$user_id);
        $select = array('cycle_start_date','cycle_expired_date');
        $prev_payment_info = $this->basic->get_data('transaction_history',$simple_where,$select,$join='',$limit='1',$start=0,$order_by='ID DESC',$group_by='');

        $prev_cycle_expired_date="";
        $price=0;
        $cycle_start_date = "";
        $cycle_expired_date = "";

        $package_data=$this->basic->get_data("package",$where=array("where"=>array("package.id"=>$package_id)));
        if(is_array($package_data) && array_key_exists(0, $package_data)) {
            $price=$package_data[0]["price"];
            $validity=$package_data[0]["validity"];
        } else {
            $redirect_url = base_url()."payment/transaction_log?action=cancel";
            redirect($redirect_url, 'refresh');
            return;
        }

        $payment_amount = isset($package_data[0]['price']) ? $package_data[0]['price'] : 0;
        $validity_str='+'.$validity.' day';

        foreach($prev_payment_info as $info){
            $prev_cycle_expired_date=$info['cycle_expired_date'];
        }

        if($prev_cycle_expired_date==""){
            $cycle_start_date=date('Y-m-d');
            $cycle_expired_date=date("Y-m-d",strtotime($validity_str,strtotime($cycle_start_date)));
        }
        else if (strtotime($prev_cycle_expired_date) < strtotime(date('Y-m-d'))){
            $cycle_start_date=date('Y-m-d');
            $cycle_expired_date=date("Y-m-d",strtotime($validity_str,strtotime($cycle_start_date)));
        }
        else if (strtotime($prev_cycle_expired_date) > strtotime(date('Y-m-d'))){
            $cycle_start_date=date("Y-m-d",strtotime('+1 day',strtotime($prev_cycle_expired_date)));
            $cycle_expired_date=date("Y-m-d",strtotime($validity_str,strtotime($cycle_start_date)));
        }

        $existing_transaction = $this->basic->get_data('transaction_history', ['where' => ['transaction_id' => $transaction_id, 'user_id' => $user_id]], ['id'], [], 1);
        if(!empty($existing_transaction)) {
            $redirect_url = base_url()."payment/transaction_log?action=success";
            redirect($redirect_url, 'refresh');
            return;
        }

        $receiver_email = isset($response['customer_email']) ? $response['customer_email'] : '';
        $country = "";
        $payment_date = isset($response['payment_date']) ? $response['payment_date'] : date('Y-m-d H:i:s');

        $insert_data=array(
            "verify_status"     =>"",
            "first_name"        =>"",
            "last_name"         =>"",
            "paypal_email"      =>"",
            "receiver_email"    =>$receiver_email,
            "country"           =>$country,
            "payment_date"      =>$payment_date,
            "payment_type"      =>'MaxelPay',
            "transaction_id"    =>$transaction_id,
            "user_id"           =>$user_id,
            "package_id"        =>$package_id,
            "cycle_start_date"  =>$cycle_start_date,
            "cycle_expired_date"=>$cycle_expired_date,
            "paid_amount"       =>$payment_amount
        );

        $this->basic->insert_data('transaction_history', $insert_data);
        $this->session->set_userdata("payment_success",1);

        $table='users';
        $where=array('id'=>$user_id);
        $data=array('expired_date'=>$cycle_expired_date,"package_id"=>$package_id,"bot_status"=>"1");
        $this->basic->update_data($table,$where,$data);

        $product_short_name = $this->config->item('product_short_name');
        $from = $this->config->item('institute_email');
        $mask = $this->config->item('product_name');
        $subject = "Payment Confirmation";

        $where = array();
        $where['where'] = array('id'=>$user_id);
        $user_email = $this->basic->get_data('users',$where,$select='');

        $payment_confirmation_email_template = $this->basic->get_data("email_template_management",array('where'=>array('template_type'=>'stripe_payment')),array('subject','message'));

        if(isset($payment_confirmation_email_template[0]) && $payment_confirmation_email_template[0]['subject'] != '' && $payment_confirmation_email_template[0]['message'] != '') {
            $to = $user_email[0]['email'];
            $url = base_url();
            $subject = $payment_confirmation_email_template[0]['subject'];
            $message = str_replace(array('#PRODUCT_SHORT_NAME#','#APP_SHORT_NAME#','#CYCLE_EXPIRED_DATE#','#SITE_URL#','#APP_NAME#'),array($product_short_name,$product_short_name,$cycle_expired_date,$url,$mask),$payment_confirmation_email_template[0]['message']);
            $this->_mail_sender($from, $to, $subject, $message, $mask, $html=1);
        } else {
            $to = $user_email[0]['email'];
            $subject = "Payment Confirmation";
            $message = "Congratulation,<br/> we have received your payment successfully. Now you are able to use {$product_short_name} system till {$cycle_expired_date}.<br/><br/>Thank you,<br/><a href='".base_url()."'>{$mask}</a> team";
            $this->_mail_sender($from, $to, $subject, $message, $mask, $html=1);
        }

        $paypal_new_payment_made_email_template = $this->basic->get_data("email_template_management",array('where'=>array('template_type'=>'stripe_new_payment_made')),array('subject','message'));

        if(isset($paypal_new_payment_made_email_template[0]) && $paypal_new_payment_made_email_template[0]['subject'] !='' && $paypal_new_payment_made_email_template[0]['message'] != '') {
            $to = $from;
            $subject = $paypal_new_payment_made_email_template[0]['subject'];
            $message = str_replace('#PAID_USER_NAME#',$user_email[0]['name'],$paypal_new_payment_made_email_template[0]['message']);
            $this->_mail_sender($from, $to, $subject, $message, $mask, $html=1);
        } else {
            $to = $from;
            $subject = "New Payment Made";
            $message = "New payment has been made by {$user_email[0]['name']}";
            $this->_mail_sender($from, $to, $subject, $message, $mask, $html=1);
        }

        if($this->addon_exist('affiliate_system')) {
            $get_affiliate_id = $this->basic->get_data("users",['where'=>['id'=>$user_id]],['affiliate_id']);
            $affiliate_id = isset($get_affiliate_id[0]['affiliate_id']) ? $get_affiliate_id[0]['affiliate_id']:0;
            if($affiliate_id != 0) {
                $this->affiliate_commission($affiliate_id,$user_id,'payment',$price);
            }
        }

        if($this->config->item("auto_relogin_after_purchase") == '1') {
            $this->session->unset_userdata('user_type');
            $this->session->unset_userdata('logged_in');
            $this->session->unset_userdata('username');
            $this->session->unset_userdata('user_id');
            $this->session->unset_userdata('download_id');
            $this->session->unset_userdata('user_login_email');
            $this->session->unset_userdata('expiry_date');
            $this->session->unset_userdata('brand_logo');
            $this->subscriber_login($user_id);
        }

        $redirect_url = base_url()."payment/transaction_log?action=success";
        redirect($redirect_url, 'refresh');
    }

