<?php

class Maxelpay{

	public $maxelpay_api_key;
	public $maxelpay_secret_key;
	public $maxelpay_mode;
	public $purpose;
	public $amount;
	public $phone;
	public $buyer_name;
	public $email;
	public $redirect_url;
	public $callback_url;
	public $button_lang;
	public $maxelpay_api_url;
	public $currency;
	public $order_id;
	public $payment_id;
	public $secondary_button = false;
	
	function __construct(){
		
		$this->CI =& get_instance();

		$query = $this->CI->db->get('payment_config');
		$config_data = $query->result_array();

		$this->maxelpay_api_key = isset($config_data[0]['maxelpay_api_key']) ? $config_data[0]['maxelpay_api_key'] : "";
		$this->maxelpay_secret_key = isset($config_data[0]['maxelpay_secret_key']) ? $config_data[0]['maxelpay_secret_key'] : "";
		$this->maxelpay_mode = isset($config_data[0]['maxelpay_mode']) ? $config_data[0]['maxelpay_mode'] : "live";
		
		// TODO: لطفاً URL های زیر را با URL های واقعی از مستندات MaxelPay تطبیق دهید
		// برای پیدا کردن URL های صحیح، به پنل مدیریت MaxelPay و بخش API Documentation مراجعه کنید
		if($this->maxelpay_mode == 'sandbox') {
			$this->maxelpay_api_url = "https://sandbox.maxelpay.com/api/v1/"; // TODO: با URL واقعی Sandbox جایگزین کنید
		} else {
			$this->maxelpay_api_url = "https://api.maxelpay.com/api/v1/"; // TODO: با URL واقعی Live جایگزین کنید
		}
	}
	
	function set_button(){

		$button_lang = !empty($this->button_lang) ? $this->button_lang : $this->CI->lang->line("Pay with MaxelPay");
	
		$button = "
			<a href='".$this->redirect_url."' class='list-group-item list-group-item-action flex-column align-items-start'>
			<div class='d-flex w-100 align-items-center'>
			<small class='text-muted'><img class='rounded' width='60' height='60' src='".base_url('assets/img/payment/maxelpay.png')."'></small>
			<h6 class='mb-1'>".$button_lang."</h6>
			</div>
			</a>";
		
		return $button;
	}

	public function create_payment()
	{
		// TODO: ساختار داده‌های زیر را با مستندات واقعی API MaxelPay تطبیق دهید
		// ممکن است نام فیلدها یا ساختار Request متفاوت باشد
		$post_data = array(
			'api_key' => $this->maxelpay_api_key,
			'secret_key' => $this->maxelpay_secret_key,
			'amount' => $this->amount,
			'currency' => $this->currency,
			'order_id' => $this->order_id,
			'description' => $this->purpose,
			'customer_name' => $this->buyer_name,
			'customer_email' => $this->email,
			'customer_phone' => $this->phone,
			'callback_url' => $this->callback_url,
			'redirect_url' => $this->redirect_url,
		);

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_URL, $this->maxelpay_api_url . "payment/create");
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data));
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Authorization: Bearer ' . $this->maxelpay_api_key
		));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		$result = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		$response = json_decode($result, true);

		// TODO: ساختار Response را با مستندات واقعی MaxelPay تطبیق دهید
		// ممکن است نام فیلدها یا ساختار Response متفاوت باشد
		if ($http_code == 200 && isset($response['status']) && $response['status'] == 'success') {
			$this->payment_id = isset($response['payment_id']) ? $response['payment_id'] : '';
			// TODO: ممکن است فیلد payment_url با نام دیگری باشد (مثلاً checkout_url یا redirect_url)
			return $response;
		} else {
			return array('status' => 'error', 'message' => isset($response['message']) ? $response['message'] : 'Payment creation failed');
		}
	}

	public function verify_payment($payment_id = '')
	{
		if (empty($payment_id)) {
			$payment_id = $this->payment_id;
		}

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $this->maxelpay_api_url . "payment/verify/" . $payment_id);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		// TODO: نوع Authentication را با مستندات MaxelPay تطبیق دهید
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Authorization: Bearer ' . $this->maxelpay_api_key // TODO: ممکن است نیاز به تغییر باشد
		));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		$result = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		$response = json_decode($result, true);

		if ($http_code == 200 && isset($response['status'])) {
			return $response;
		} else {
			return array('status' => 'error', 'message' => isset($response['message']) ? $response['message'] : 'Payment verification failed');
		}
	}

	public function success_action()
	{
		$payment_id = isset($_GET['payment_id']) ? $_GET['payment_id'] : '';
		if (empty($payment_id)) {
			$payment_id = isset($_POST['payment_id']) ? $_POST['payment_id'] : '';
		}

		if (empty($payment_id)) {
			return array('status' => 'error', 'message' => 'Payment ID not found');
		}

		$this->payment_id = $payment_id;
		return $this->verify_payment($payment_id);
	}
}
